/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailTemplate
extends DescriptiveObject
implements Serializable {
    static final long serialVersionUID = -6554492141713428111L;
    private static final String TRACE_MASKT = "XNTYEMTT";
    private static final String TRACE_MASKF = "XNTYEMTF";
    private static final String TRACE_MASKD = "XNTYEMTD";
    public String _to;
    public String _from;
    public String _subject;
    public String _message;
    Map _substitutions;

    EmailTemplate() {
    }

    public EmailTemplate(String name, String description, String to, String from, String subject, String message) {
        super(name, description);
        Trace.trace(TRACE_MASKT, "-> EmailTemplate(" + name + ")");
        this._to = to;
        this._from = from;
        this._subject = subject;
        this._message = message;
        Trace.trace(TRACE_MASKT, "<- EmailTemplate");
    }

    public void resolveWith(Map substitutions) {
        this._substitutions = substitutions;
    }

    private String resolve(String template) {
        Trace.trace(TRACE_MASKT, "-> resolve(" + template + ")");
        String resolved = template;
        if (this._substitutions != null) {
            Iterator i = this._substitutions.entrySet().iterator();
            Map.Entry entry = null;
            Matcher matcher = null;
            while (i.hasNext()) {
                entry = i.next();
                matcher = ((Pattern)entry.getKey()).matcher(resolved);
                resolved = matcher.replaceAll((String)entry.getValue());
            }
        }
        Trace.trace(TRACE_MASKT, "<- resolve " + resolved);
        return resolved;
    }

    public String to() {
        return this.resolve(this._to);
    }

    public String from() {
        return this.resolve(this._from);
    }

    public String subject() {
        return this.resolve(this._subject);
    }

    public String message() {
        return this.resolve(this._message);
    }
}

